﻿<%@ Import Namespace="Soneta.Kalend" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Urlopy - plan</title>
		<script runat="server">

	public class PrnParams: ContextBase {
	
		public PrnParams(Context context): base(context) {
			UstawRok();
		}

        FromTo okres;
        [Caption("Plan urlopów za okres")]
        [Priority(10)]
        public FromTo Okres {
            get { return okres; }
            set {
                if (value == FromTo.Empty || value == FromTo.All)
                    UstawRok();
                else
                    okres = value;
                OnChanged(EventArgs.Empty);
            }
        }
       		
		void UstawRok() {
			Date data;
			if (Context.Contains(typeof(ActualDate)))
				data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
			else
				data = Date.Today;
			okres = FromTo.Year(data.Year);
		}		
	}
	
	PrnParams pars = null; 
	[Context(Required=true)] 
	public PrnParams Params { 
		set { pars = value; } 
	} 

	KalendModule kalend;
	DefinicjaLimitu definicja;
	
	void OnContextLoad(Object sender, EventArgs args) {
		if (pars.Okres==FromTo.Year(pars.Okres.To.Year))
			ReportHeader1["OKRES"] = "na " + pars.Okres.To.Year + " rok";
		else
			ReportHeader1["OKRES"] = "za okres " + pars.Okres.ToString();
	
		kalend = KalendModule.GetInstance(dc);
        definicja = kalend.DefinicjeLimitow.WgNazwy["Urlop wypoczynkowy prac.tymcz."];

        ReportHeader1["DEFINICJA"] = definicja.Nazwa;
	}
	
    void Grid1_BeforeRow(Object sender, RowEventArgs args) {
		PracHistoria ph = (PracHistoria)args.Row;

        if (ph.Etat.RodzajZatrudnienia != RodzajZatrudnienia.PracownikTymczasowy &&
           ph.Etat.RodzajZatrudnienia != RodzajZatrudnienia.PracownikTymczasowyZaGranicą) {
            args.VisibleRow = false;
            return;
        }

        KalkulatorPracy kalk = new KalkulatorPracy(ph.Pracownik);

        int nieob = 0;
        FromTo okresP = new FromTo(Date.MinValue, pars.Okres.From-1);
        foreach (OkresNieobecności n in kalk.Nieobecnosci(okresP, true))
            if (n.Definicja.Limit == definicja) {
                Nieobecnosc no = (Nieobecnosc)n;
                if (no.Okres.Days == 1)
                    nieob += no.Okres.Days;
                else
                    nieob += kalk.Plan.Norma(n.Okres).Dni;
            }

        int limit = 0;
        int korekta = 0;
        FromTo okres = FromTo.Empty;
        IList limity = kalend.LimNieobecnosci.WgPracownik[ph.Pracownik, definicja][pars.Okres];
        if (limity.Count != 0) {
            LimitNieobecnosci l = (LimitNieobecnosci)limity[limity.Count - 1];
            limit = l.Razem + nieob;
            korekta = l.Zmiana;
            okres = l.Okres;
        }

        int plan = 0;
        string s14 = "";
        string sp = "";
        string sd = "";
        foreach (OkresNieobecności n in kalk.Nieobecnosci(pars.Okres, true))
			if (n.Definicja.Limit == definicja) {
			    if (n.Okres.Days>=14) {
				    s14 += "<br>" + n.Okres;
				    sp += "<br>";				
			    }
			    else {
				    s14 += "<br>";				
				    sp += "<br>" + n.Okres;
 			    }
                Nieobecnosc no = (Nieobecnosc)n;
                int dni;
                if (no.Okres.Days == 1)
                    dni = no.Okres.Days;
                else
                    dni = kalk.Plan.Norma(n.Okres).Dni;
                plan += dni;
                if (!okres.Contains(n.Okres))
                    limit += dni;
 			    sd += "<br>" + dni;
            }

        limitP.EditValue = nieob;
        limitD.EditValue = limit;
        limitK.EditValue = korekta;
        termin14.EditValue = s14 == "" ? "" : s14.Substring(4, s14.Length - 4);
        termin.EditValue = sp == "" ? "" : sp.Substring(4, sp.Length - 4);
        urlopD.EditValue = sd == "" ? "" : sd.Substring(4, sd.Length - 4);
        resztaD.EditValue = Formatuj(limit + korekta - nieob - plan);
    }

    string Formatuj(int dni) {
        if (dni <= 0)
            return "";
        return string.Format("{0}", dni);
    }
     
	public static object Msg(object obj) {
		return obj;
	}

		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="UrlopyPlan" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" LeftMargin="-1" TypeName="Soneta.Business.Row[], Soneta.Business"
				oncontextload="OnContextLoad" Landscape="True"></ea:datacontext>
            <cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" 
                title="Plan urlopów %OKRES%|&lt;/strong&gt;Definicja: &lt;strong&gt; %DEFINICJA%" 
                runat="server"></cc1:reportheader><ea:grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" RowTypeName="Soneta.Kadry.PracHistoria, Soneta.KadryPlace"
				LinkedRows="History">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." ID="lp" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="25" DataMember="Etat.Wydzial.Kod" Caption="Nazwa działu zakładu pracy" NoWrap="True" runat="server"></ea:GridColumn>
					<ea:GridColumn DataMember="Pracownik.NazwiskoImię" Caption="Nazwisko i imię pracownika" NoWrap="False" runat="server"></ea:GridColumn>
                    <ea:GridColumn Width="16" Align="Center" Caption="Liczba dni urlopu wykorzystanego w poprzednich latach" HideZero="True" ID="limitP" runat="server"></ea:GridColumn>
                    <ea:GridColumn Width="7" Align="Center" Caption="Limit urlopu~dni" HideZero="True" ID="limitD" runat="server"></ea:GridColumn>
                    <ea:GridColumn ID="limitK" runat="server" Align="Center" Caption="Limit urlopu~korekta" HideZero="True" Width="7">
                    </ea:GridColumn>
					<ea:GridColumn Width="21" Caption="Planowany termin&lt;br&gt;(co najmniej 14 dni)" HideZero="True"
						ID="termin14" VAlign="Top" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="21" Caption="Planowany termin&lt;br&gt;(pozostałe)" HideZero="True" ID="termin"
						VAlign="Top" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="7" Align="Center" Caption="Liczba dni urlopu" HideZero="True" ID="urlopD"
						VAlign="Top" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="9" Align="Center" Caption="Pozostało~dni" HideZero="True" ID="resztaD" runat="server"></ea:GridColumn>
				</Columns>
			</ea:grid><cc1:reportfooter id="ReportFooter1" runat="server"></cc1:reportfooter></form>
	</body>
</HTML>
